/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Debugger
**
** DESCRIPTION:	Handles in-game debuggers
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef DEBUGGER_H
#define DEBUGGER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "DebuggerInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Debugger_c_iMaxDebuggers = 8;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CDebugger
{
private:

	//class data
	bool			m_bIsActive;

	IDebugger *		m_pDebugger[Debugger_c_iMaxDebuggers];
	int				m_iNumDebuggers;
	int				m_iCurrentDebugger;

	ldwPoint		m_sLinePos;

	//class methods
	//setup
	public:		CDebugger(void);
	public:		void Reset();

	// process
	public:		const bool Register(IDebugger *pDebugger);

	public:		void AddLine(const char *psDebugLine, ...);

	public:		void Draw();
	public:		const bool HandleKeyCharacter(const char cKey);
	public:		const bool HandleKeyDown(const int iKeyCode);
	public:		const bool HandleKeyUp(const int iKeyCode);

	// access
	public:		const bool IsActive() const { return m_bIsActive; }
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CDebugger		Debugger;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/